/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.model.weapon;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.model.AbstractSolidEntityModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimationPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;

public abstract class AbstractWeaponModel
extends AbstractSolidEntityModel {
    private final List<SpecialRenderer<?>> specialRenderers = new ArrayList();
    private IRenderCallback bulletRenderer;

    public SpecialRenderer<?> setSpecialRenderer(AnimationStage stage, ModelRenderer renderer) {
        return this.setSpecialRenderer(new SpecialRenderer<ModelRenderer>(stage, renderer, (renderObj, data, poseStack, vertexBuilder, light, overlay) -> renderObj.func_228308_a_(poseStack, vertexBuilder, light, overlay)));
    }

    public SpecialRenderer<?> setSpecialRenderer(AnimationStage stage, Function<IPlayerData, ModelRenderer> selector) {
        return this.setSpecialRenderer(new SpecialRenderer<Function>(stage, selector, (renderObj, data, poseStack, vertexBuilder, light, overlay) -> ((ModelRenderer)renderObj.apply(data)).func_228308_a_(poseStack, vertexBuilder, light, overlay)));
    }

    public SpecialRenderer<?> setSpecialRenderer(AnimationStage stage, Predicate<ItemStack> condition, ModelRenderer renderer) {
        return this.setSpecialRenderer(new SpecialRenderer<Predicate>(stage, condition, (renderObj, data, poseStack, vertexBuilder, light, overlay) -> {
            ItemStack held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            if (condition.test(held)) {
                renderer.func_228308_a_(poseStack, vertexBuilder, light, overlay);
            }
        }));
    }

    public SpecialRenderer<?> setSpecialRenderer(SpecialRenderer<?> cubeRenderer) {
        this.specialRenderers.add(cubeRenderer);
        if (cubeRenderer.builtInAnimations()) {
            this.bulletRenderer = cubeRenderer::renderCubes;
        }
        return cubeRenderer;
    }

    public final void func_225598_a_(MatrixStack p_225598_1_, IVertexBuilder p_225598_2_, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
    }

    public final void render(ItemStack stack, IPlayerData data, MatrixStack matrix, IRenderTypeBuffer typeBuffer, IVertexBuilder builder, int light, int overlay, boolean heldFp) {
        this.renderWeapon(stack, data, matrix, builder, light, overlay);
        if (heldFp) {
            this.renderAnimated(data, matrix, typeBuffer, builder, light, overlay);
        } else {
            this.renderStatic(data, matrix, typeBuffer, builder, light, overlay);
        }
    }

    public final IRenderCallback getBulletRenderer() {
        return this.bulletRenderer;
    }

    public List<SpecialRenderer<?>> getSpecialRenderers() {
        return ImmutableList.copyOf(this.specialRenderers);
    }

    protected abstract void renderWeapon(ItemStack var1, IPlayerData var2, MatrixStack var3, IVertexBuilder var4, int var5, int var6);

    protected SpecialRenderer<?> setBulletRenderer(SpecialRenderer<?> renderer) {
        this.bulletRenderer = renderer::renderCubes;
        renderer.setSpecial();
        return renderer;
    }

    private void renderStatic(IPlayerData data, MatrixStack matrix, IRenderTypeBuffer typeBuffer, IVertexBuilder builder, int light, int overlay) {
        for (SpecialRenderer<?> specialRenderer : this.specialRenderers) {
            specialRenderer.renderCubes(data, matrix, builder, light, overlay);
        }
    }

    private void renderAnimated(IPlayerData data, MatrixStack matrix, IRenderTypeBuffer typeBuffer, IVertexBuilder builder, int light, int overlay) {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        for (SpecialRenderer<?> specialRenderer : this.specialRenderers) {
            matrix.func_227860_a_();
            pipeline.animateStage(((SpecialRenderer)specialRenderer).targetStage, matrix, typeBuffer, light, overlay);
            specialRenderer.renderCubes(data, matrix, builder, light, overlay);
            matrix.func_227865_b_();
        }
    }

    public static interface IRenderCallback {
        public void renderSpecial(IPlayerData var1, MatrixStack var2, IVertexBuilder var3, int var4, int var5);
    }

    static interface IRenderer<T> {
        public void renderAnimated(T var1, IPlayerData var2, MatrixStack var3, IVertexBuilder var4, int var5, int var6);
    }

    public static class SpecialRenderer<T> {
        private final AnimationStage targetStage;
        private final T renderObj;
        private final IRenderer<T> objRenderer;
        private boolean specialAnimations;

        SpecialRenderer(AnimationStage targetStage, T renderObj, IRenderer<T> objRenderer) {
            this.targetStage = targetStage;
            this.renderObj = renderObj;
            this.objRenderer = objRenderer;
        }

        public void setSpecial() {
            this.specialAnimations = true;
        }

        public void renderCubes(IPlayerData data, MatrixStack poseStack, IVertexBuilder vertexBuilder, int light, int overlay) {
            this.objRenderer.renderAnimated(this.renderObj, data, poseStack, vertexBuilder, light, overlay);
        }

        public boolean builtInAnimations() {
            return this.specialAnimations;
        }

        public AnimationStage target() {
            return this.targetStage;
        }
    }
}

